#!/usr/bin/env octave

xambi_base_filename = argv(){1};
pfs_filename = argv(){2};
#note ppm_filename must have a image extension that pfsout understands
# It is best to use a HDR image format (uses floating point for storing pixels)
# .pfs and .exr are the most common hdr file formats
#
# You can also use one of the non-hdr image formats pfs supports
# pfsin --help
#Recognized file formats and extensions:
# Radiance RGBE - .pic, .hdr
# TIFF (incl. LogLuv) - .tiff, .tif
# PNM, PPM - .ppm, .pnm
# JPEG - .jpeg, .jpg
# PNG - .png
# PFS - .pfs
# OpenEXR - .exr
# PFM - .pfm
# DPX - .dpx
# GIF - .gif
# BMP - .bmp
# EPS - .eps
# Canon 350D RAW - .cr2
# (and other camera RAW formats recognized by dcraw)
[nr1,nc1]=size(xambi_base_filename);
num_characters=nc1+6;
xambi_filenames=blanks(num_characters);
num_files=10;
for fn=1:num_files
  xambi_filenames(fn,:)=[xambi_base_filename,num2str(fn-1),".xref"];
endfor;
tmp=xambi_filenames
#xambi_filenames=["out_dvbt_chan24_amersfoort_8/dvbt_chan24_amersfoort_8.0000.xref";
#                 "out_dvbt_chan24_amersfoort_8/dvbt_chan24_amersfoort_8.0001.xref";
#                 "out_dvbt_chan24_amersfoort_8/dvbt_chan24_amersfoort_8.0002.xref";
#                 "out_dvbt_chan24_amersfoort_8/dvbt_chan24_amersfoort_8.0003.xref"]

a1 = read_xambi(xambi_filenames(1,:));
[sizexa1,sizeya1]=size(a1)
[nr,nc]=size(a1)
#[nr2,nc2]=size(xambi_filenames)
a_multi=zeros(num_files,nc);
  for x=1:num_files
    a_finite=filter_nonfinite(read_xambi(xambi_filenames(x,:)));
    a_multi(x,:)=a_finite;
  endfor;

plot_xambi_to_file_pfs(a_multi, pfs_filename);

