%
% Copyright 2009 Free Software Foundation, Inc.
% 
% This file is part of GNU Radio
% 
% GNU Radio is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 3, or (at your option)
% any later version.
% 
% GNU Radio is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with GNU Radio; see the file COPYING.  If not, write to
% the Free Software Foundation, Inc., 51 Franklin Street,
% Boston, MA 02110-1301, USA.
% 

function v = scale (M,minval,maxval)

  %% usage: scale (M)
  %%
  %%  scale all values in matrix to fall within range minval,maxval
  %%  All values in matrix have to be finite (use filter_nonfinite before if needed)

  maxval1=max(max(M));
  minval1=min(min(M));
  v=M-minval1;
  maxval2=max(max(v));
  minval2=min(min(v));
  v=(maxval-minval)*v/maxval2+minval;
  maxval3=max(max(v))
  minval3=min(min(v))

