#!/usr/bin/env python
##################################################
# Gnuradio Python Flow Graph
# Title: Convert complex short to complex float file
# Author: Martin Dudok van Heel
# Description: Convert a file in complex short format to complex float format
# Generated: Thu Aug 27 22:21:01 2009
##################################################

from gnuradio import gr
from gnuradio.eng_option import eng_option
from optparse import OptionParser

class cshort_to_cfloat_file(gr.top_block):

	def __init__(self, infile="None", outfile="None"):
		gr.top_block.__init__(self, "Convert complex short to complex float file")

		##################################################
		# Parameters
		##################################################
		self.infile = infile
		self.outfile = outfile

		##################################################
		# Blocks
		##################################################
		self.file_sink = gr.file_sink(gr.sizeof_gr_complex*1, outfile)
		self.file_source = gr.file_source(gr.sizeof_short*1, infile, False)
		self.gr_interleaved_short_to_complex_0 = gr.interleaved_short_to_complex()

		##################################################
		# Connections
		##################################################
		self.connect((self.file_source, 0), (self.gr_interleaved_short_to_complex_0, 0))
		self.connect((self.gr_interleaved_short_to_complex_0, 0), (self.file_sink, 0))

	def set_infile(self, infile):
		self.infile = infile

	def set_outfile(self, outfile):
		self.outfile = outfile

if __name__ == '__main__':
	parser = OptionParser(option_class=eng_option, usage="%prog: [options]")
	parser.add_option("-i", "--infile", dest="infile", type="string", default="None",
		help="Set Infile [default=%default]")
	parser.add_option("-o", "--outfile", dest="outfile", type="string", default="None",
		help="Set Outfile [default=%default]")
	(options, args) = parser.parse_args()
	tb = cshort_to_cfloat_file(infile=options.infile, outfile=options.outfile)
	tb.run()
	#raw_input('Press Enter to quit: ')
	#tb.stop()

